<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class DailyReport extends CI_Controller {

	public function __construct() {
		parent::__construct();
		if($this->session->userdata('user_logged_in') != true)
		{
			$this->session->set_flashdata('response','<div class="alert alert-error">Unauthorised access. Login required.</div>');
			redirect('login');
		}
		$this->load->library('form_validation');
		//$this->load->library('pagination');
		$this->load->model('Report_model');
	}		
	public function index() {
		$data['report_type'] = "confirmed qoute";	
		$division_list = $this->crud_model->get_list('division_id','division_name','company_division');
		$data['division_list'] = $division_list;
		$data['submitted_division_id'] = 7;
		$data['records']= false;
		$data['invoice_records'] = false;
		$data['receipt_records'] = false;
		$data['credit_note_records'] = false;
		$data['purchase_invoice_records'] = false;
		$data['payment_records'] = false;
		$data['debit_note_records'] = false;
		$data['general_receipt_records'] = false;
		$data['general_payment_records'] = false;
		$data['journal_records'] = false;
		$this->load->view('templates/header');
		$this->load->view('reports/daily_report',$data);
		$this->load->view('templates/footer');		
	}
	public function search_result() {
		if($this->input->post('report_date_from') != '') {
			/* if($this->input->post('division') and $this->input->post('division')!="select" ) {
				$where['quotation_divisionid'] = $this->input->post('division');
			}
			$where['quotation_status'] = "Confirmed";
			if($this->input->post('report_date_from') != ''  or $this->input->post('report_date_to') != '' ) {

				$date_fmt= date('Y-m-d',strtotime($this->input->post('report_date_from')));
				$date_to= date('Y-m-d',strtotime($this->input->post('report_date_to')));

				if($this->input->post('report_date_from')!='' and $this->input->post('report_date_to')!='') {
					$where['quotation_confirmationdate >='] = $date_fmt;
					$where['quotation_confirmationdate <='] = $date_to;
				}
				else if($this->input->post('report_date_from') != '') {
					$where['quotation_confirmationdate >='] = $date_fmt;
				}
				else if($this->input->post('report_date_to')!=''){
					$where['quotation_confirmationdate <='] = $date_to;
				}

			}
			$data['records']=$this->crud_model->get('view_furniture_quotations_client_project_users', $where, null, null, "quotation_confirmationdate", "quotation_confirmationdate");
			 */
			if($this->input->post('filter_by')==0 || $this->input->post('filter_by')==="Invoice"){
				$where['quotation_status'] = "Confirmed";
				$this->db->select('*');
				$this->db->from('furniture_invoice');
				$this->db->join('company_division', 'company_division.division_id = furniture_invoice.quotation_divisionid','inner');
				if($this->input->post('report_date_from') != '' or $this->input->post('report_date_to') != '' ) {
					$date_fmt= date('Y-m-d',strtotime($this->input->post('report_date_from')));
					$date_to= date('Y-m-d',strtotime($this->input->post('report_date_to')));

					if($this->input->post('report_date_from')!='' and $this->input->post('report_date_to')!='') {
						$this->db->where('DATE(invoice_date) >=', $date_fmt);
						$this->db->where('DATE(invoice_date) <=', $date_to);
					}
					else if($this->input->post('report_date_from') != '') {
						$this->db->where('DATE(invoice_date) >=', $date_fmt);
					}
					else if($this->input->post('report_date_to')!=''){
						$this->db->where('DATE(invoice_date) <=', $date_to);
					}
				}
				if($this->input->post('division') and $this->input->post('division')!="select" ) {
					$this->db->where('furniture_invoice.quotation_divisionid', $this->input->post('division'));
				}
				$this->db->order_by("invoice_date","DESC");
				$rs = $this->db->get();
				$data['invoice_records'] = $rs->result_array();
			} else {
				$data['invoice_records'] = false;
			}
			if($this->input->post('filter_by')==0 || $this->input->post('filter_by')==="Receipt"){
				$this->db->select('receipt_id,furniture_receipts.quotation_divisionid,receipt_status,division_code,receipt_number,receipt_code,receipt_date,client_name,currency_code,receipt_cancelled_date,user_name,receipt_cancelledby,furniture_receipts.receipt_amount,furniture_receipts.receipt_discount');
				$this->db->from('furniture_receipts');
				$this->db->join('company_division', 'company_division.division_id = furniture_receipts.quotation_divisionid','inner');
				$this->db->join('users', 'users.user_id = furniture_receipts.receipt_generatedby','inner');
				$this->db->join('new_client_master', 'new_client_master.client_id = furniture_receipts.client_id','inner');
				if($this->input->post('division') and $this->input->post('division')!="select" ) {
					$this->db->where('furniture_receipts.quotation_divisionid', $this->input->post('division'));
				}
				if($this->input->post('report_date_from') != ''  or $this->input->post('report_date_to') != '' ) {

					$date_fmt= date('Y-m-d',strtotime($this->input->post('report_date_from')));
					$date_to= date('Y-m-d',strtotime($this->input->post('report_date_to')));

					if($this->input->post('report_date_from')!='' and $this->input->post('report_date_to')!='') {
						$this->db->where('DATE(receipt_date) >=', $date_fmt);
						$this->db->where('DATE(receipt_date) <=', $date_to);
					}
					else if($this->input->post('report_date_from') != '') {
						$this->db->where('DATE(receipt_date) >=', $date_fmt);
					}
					else if($this->input->post('report_date_to')!=''){
						$this->db->where('DATE(receipt_date) <=', $date_to);
					}

				}
				$this->db->order_by("receipt_date","DESC");
				$rs = $this->db->get();
				$data['receipt_records'] = $rs->result_array();
			}else {
				$data['receipt_records'] = false;
			}
			if($this->input->post('filter_by')==0 || $this->input->post('filter_by')==="Credit Note"){
				$this->db->select('credit_note_id,quotation_divisionid,credit_note_number,credit_note_code,credit_note_date,credit_note_status,net_amount,currency_code,user_name,client_name');
				$this->db->from('credit_note');
				$this->db->join('company_division', 'company_division.division_id = credit_note.quotation_divisionid','inner');
				$this->db->join('users', 'users.user_id = credit_note.credit_note_generatedby','inner');
				$this->db->join('new_client_master', 'new_client_master.client_id = credit_note.client_id','inner');
				if($this->input->post('division') and $this->input->post('division')!="select" ) {
					$this->db->where('credit_note.quotation_divisionid', $this->input->post('division'));
				}
				if($this->input->post('report_date_from') != ''  or $this->input->post('report_date_to') != '' ) {

					$date_fmt= date('Y-m-d',strtotime($this->input->post('report_date_from')));
					$date_to= date('Y-m-d',strtotime($this->input->post('report_date_to')));

					if($this->input->post('report_date_from')!='' and $this->input->post('report_date_to')!='') {
						$this->db->where('DATE(credit_note_date) >=', $date_fmt);
						$this->db->where('DATE(credit_note_date) <=', $date_to);
					}
					else if($this->input->post('report_date_from') != '') {
						$this->db->where('DATE(credit_note_date) >=', $date_fmt);
					}
					else if($this->input->post('report_date_to')!=''){
						$this->db->where('DATE(credit_note_date) <=', $date_to);
					}

				}
				$this->db->order_by("credit_note_date","DESC");
				$rs = $this->db->get();
				$data['credit_note_records'] = $rs->result_array();
			} else {
				$data['credit_note_records'] = false;
			}

			if($this->input->post('filter_by')==0 || $this->input->post('filter_by')==="Purchase Invoice"){
				$this->db->select('id,purchase_h.division_id,purchase_no,purchase_invoice_code,purchase_date,purchase_h.status,pur_net_amt,currency_code,user_name,supplier_name');
				$this->db->from('purchase_h');
				$this->db->join('company_division', 'company_division.division_id = purchase_h.division_id','inner');
				$this->db->join('users', 'users.user_id = purchase_h.user_id','inner');
				$this->db->join('supplier_master', 'supplier_master.supplier_id = purchase_h.supplier_id','inner');
				if($this->input->post('division') and $this->input->post('division')!="select" ) {
					$this->db->where('purchase_h.division_id', $this->input->post('division'));
				}
				if($this->input->post('report_date_from') != ''  or $this->input->post('report_date_to') != '' ) {

					$date_fmt= date('Y-m-d',strtotime($this->input->post('report_date_from')));
					$date_to= date('Y-m-d',strtotime($this->input->post('report_date_to')));

					if($this->input->post('report_date_from')!='' and $this->input->post('report_date_to')!='') {
						$this->db->where('DATE(purchase_date) >=', $date_fmt);
						$this->db->where('DATE(purchase_date) <=', $date_to);
					}
					else if($this->input->post('report_date_from') != '') {
						$this->db->where('DATE(purchase_date) >=', $date_fmt);
					}
					else if($this->input->post('report_date_to')!=''){
						$this->db->where('DATE(purchase_date) <=', $date_to);
					}

				}
				$this->db->order_by("purchase_date","DESC");
				$rs = $this->db->get();
				$data['purchase_invoice_records'] = $rs->result_array();
			} else {
				$data['purchase_invoice_records'] = false;
			}
			if($this->input->post('filter_by')==0 || $this->input->post('filter_by')==="Supplier Payment"){
				$this->db->select('payment_id,furniture_payments.quotation_divisionid,payment_number,payment_code,payment_date,furniture_payments.payment_status,payment_amount,currency_code,user_name,supplier_name');
				$this->db->from('furniture_payments');
				$this->db->join('company_division', 'company_division.division_id = furniture_payments.quotation_divisionid','inner');
				$this->db->join('users', 'users.user_id = furniture_payments.payment_generatedby','inner');
				$this->db->join('supplier_master', 'supplier_master.supplier_id = furniture_payments.client_id','inner');
				if($this->input->post('division') and $this->input->post('division')!="select" ) {
					$this->db->where('furniture_payments.quotation_divisionid', $this->input->post('division'));
				}
				if($this->input->post('report_date_from') != ''  or $this->input->post('report_date_to') != '' ) {

					$date_fmt= date('Y-m-d',strtotime($this->input->post('report_date_from')));
					$date_to= date('Y-m-d',strtotime($this->input->post('report_date_to')));

					if($this->input->post('report_date_from')!='' and $this->input->post('report_date_to')!='') {
						$this->db->where('DATE(payment_date) >=', $date_fmt);
						$this->db->where('DATE(payment_date) <=', $date_to);
					}
					else if($this->input->post('report_date_from') != '') {
						$this->db->where('DATE(payment_date) >=', $date_fmt);
					}
					else if($this->input->post('report_date_to')!=''){
						$this->db->where('DATE(payment_date) <=', $date_to);
					}
				}
				$this->db->order_by("payment_date","DESC");
				$rs = $this->db->get();
				$data['payment_records'] = $rs->result_array();
			} else {
				$data['payment_records'] = false;
			}

			if($this->input->post('filter_by')==0 || $this->input->post('filter_by')==="Debit Note"){
				$this->db->select('debit_note_id,debit_note.quotation_divisionid,debit_note_number,debit_note_code,debit_note_date,debit_note.debit_note_status,net_amount,currency_code,user_name,supplier_name');
				$this->db->from('debit_note');
				$this->db->join('company_division', 'company_division.division_id = debit_note.quotation_divisionid','inner');
				$this->db->join('users', 'users.user_id = debit_note.debit_note_generatedby','inner');
				$this->db->join('supplier_master', 'supplier_master.supplier_id = debit_note.supplier_id','inner');
				if($this->input->post('division') and $this->input->post('division')!="select" ) {
					$this->db->where('debit_note.quotation_divisionid', $this->input->post('division'));
				}
				if($this->input->post('report_date_from') != ''  or $this->input->post('report_date_to') != '' ) {

					$date_fmt= date('Y-m-d',strtotime($this->input->post('report_date_from')));
					$date_to= date('Y-m-d',strtotime($this->input->post('report_date_to')));

					if($this->input->post('report_date_from')!='' and $this->input->post('report_date_to')!='') {
						$this->db->where('DATE(debit_note_date) >=', $date_fmt);
						$this->db->where('DATE(debit_note_date) <=', $date_to);
					}
					else if($this->input->post('report_date_from') != '') {
						$this->db->where('DATE(debit_note_date) >=', $date_fmt);
					}
					else if($this->input->post('report_date_to')!=''){
						$this->db->where('DATE(debit_note_date) <=', $date_to);
					}

				}
				$this->db->order_by("debit_note_date","DESC");
				$rs = $this->db->get();
				$data['debit_note_records'] = $rs->result_array();
			} else {
				$data['debit_note_records'] = false;
			}
			if($this->input->post('filter_by')==0 || $this->input->post('filter_by')==="General Receipt"){
				$this->db->select('g_receipt_id,general_receipts.division_id,general_receipt_no,general_receipt_code,general_receipt_date,general_receipts.general_receipt_status,receipt_amount,currency_code,user_name,cash_amount,c_card_amount,c_card_type,wallet_amount,wallet_type,cheque_amount');
				$this->db->from('general_receipts');
				$this->db->join('company_division', 'company_division.division_id = general_receipts.division_id','inner');
				$this->db->join('users', 'users.user_id = general_receipts.receipt_generatedby','inner');
				if($this->input->post('division') and $this->input->post('division')!="select" ) {
					$this->db->where('general_receipts.division_id', $this->input->post('division'));
				}
				if($this->input->post('report_date_from') != ''  or $this->input->post('report_date_to') != '' ) {

					$date_fmt= date('Y-m-d',strtotime($this->input->post('report_date_from')));
					$date_to= date('Y-m-d',strtotime($this->input->post('report_date_to')));

					if($this->input->post('report_date_from')!='' and $this->input->post('report_date_to')!='') {
						$this->db->where('DATE(general_receipt_date) >=', $date_fmt);
						$this->db->where('DATE(general_receipt_date) <=', $date_to);
					}
					else if($this->input->post('report_date_from') != '') {
						$this->db->where('DATE(general_receipt_date) >=', $date_fmt);
					}
					else if($this->input->post('report_date_to')!=''){
						$this->db->where('DATE(general_receipt_date) <=', $date_to);
					}

				}
				$this->db->order_by("general_receipt_date","DESC");
				$rs = $this->db->get();
				$data['general_receipt_records'] = $rs->result_array();
			} else {
				$data['general_receipt_records'] = false;
			}
			if($this->input->post('filter_by')==0 || $this->input->post('filter_by')==="General Payment"){
				$this->db->select('g_payment_id,general_payments.division_id,general_payment_no,general_payment_code,general_payment_date,general_payments.general_payment_status,payment_amount,currency_code,user_name,cash_amount,c_card_amount,c_card_type,wallet_amount,wallet_type,cheque_amount');
				$this->db->from('general_payments');
				$this->db->join('company_division', 'company_division.division_id = general_payments.division_id','inner');
				$this->db->join('users', 'users.user_id = general_payments.payment_generatedby','inner');
				if($this->input->post('division') and $this->input->post('division')!="select" ) {
					$this->db->where('general_payments.division_id', $this->input->post('division'));
				}
				if($this->input->post('report_date_from') != ''  or $this->input->post('report_date_to') != '' ) {

					$date_fmt= date('Y-m-d',strtotime($this->input->post('report_date_from')));
					$date_to= date('Y-m-d',strtotime($this->input->post('report_date_to')));

					if($this->input->post('report_date_from')!='' and $this->input->post('report_date_to')!='') {
						$this->db->where('DATE(general_payment_date) >=', $date_fmt);
						$this->db->where('DATE(general_payment_date) <=', $date_to);
					}
					else if($this->input->post('report_date_from') != '') {
						$this->db->where('DATE(general_payment_date) >=', $date_fmt);
					}
					else if($this->input->post('report_date_to')!=''){
						$this->db->where('DATE(general_payment_date) <=', $date_to);
					}

				}
				$this->db->order_by("general_payment_date","DESC");
				$rs = $this->db->get();
				$data['general_payment_records'] = $rs->result_array();
			} else {
				$data['general_payment_records'] = false;
			}
			if($this->input->post('filter_by')==0 || $this->input->post('filter_by')==="Journal"){
				$this->db->select('journal_id,journal.division_id,journal_no,journal_code,journal_date,journal.journal_status,dr_amount,cr_amount,currency_code,user_name');
				$this->db->from('journal');
				$this->db->join('company_division', 'company_division.division_id = journal.division_id','inner');
				$this->db->join('users', 'users.user_id = journal.journal_generatedby','inner');
				if($this->input->post('division') and $this->input->post('division')!="select" ) {
					$this->db->where('journal.division_id', $this->input->post('division'));
				}
				if($this->input->post('report_date_from') != ''  or $this->input->post('report_date_to') != '' ) {

					$date_fmt= date('Y-m-d',strtotime($this->input->post('report_date_from')));
					$date_to= date('Y-m-d',strtotime($this->input->post('report_date_to')));

					if($this->input->post('report_date_from')!='' and $this->input->post('report_date_to')!='') {
						$this->db->where('DATE(journal_date) >=', $date_fmt);
						$this->db->where('DATE(journal_date) <=', $date_to);
					}
					else if($this->input->post('report_date_from') != '') {
						$this->db->where('DATE(journal_date) >=', $date_fmt);
					}
					else if($this->input->post('report_date_to')!=''){
						$this->db->where('DATE(journal_date) <=', $date_to);
					}

				}
				$this->db->order_by("journal_date","DESC");
				$rs = $this->db->get();
				//echo $this->db->last_query().'<br>';
				$data['journal_records'] = $rs->result_array();
			} else {
				$data['journal_records'] = false;
			}
			$division_list = $this->crud_model->get_list('division_id','division_name','company_division');
			$data['division_list'] = $division_list;
			$data['submitted_division_id'] = $this->input->post('division');
			$this->load->view('templates/header');
			$this->load->view('reports/daily_report',$data);
			$this->load->view('templates/footer');
			
		}else{
			$this->index();
		}
	}
	function date_check($data) {
		$given_date = strtotime($data);
		$today_date = strtotime(date('Y-m-d'));
		/* echo date('Y-m-d',$given_date);
		 echo date('Y-m-d',$today_date);
		exit ; */
		if($given_date <= $today_date){
			//true
			return true;
		}
		else{
			//false
			$this->form_validation->set_message('date_check', 'Date cannot be future date');
			return FALSE;
		}

	}		
}
?>